package com.elitesland.cbpl.rosefinch.client.constant;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/10/10
 */
@Getter
public enum RosefinchType {

    /**
     * 类型
     */
    BUSINESS(1, "常规类型"),
    BATCH(2, "批处理类型"),
    EXPORT(3, "导出类型"),
    REFLECT(4, "反射类型"),
    ;

    private final Integer code;
    private final String desc;

    RosefinchType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        if (ObjectUtil.isNull(code)) return null;
        for (RosefinchType status : RosefinchType.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return BUSINESS.getDesc();
    }

    public static List<EnumValues> enumValues() {
        return Arrays.stream(RosefinchType.values())
                .map(name -> EnumValues.of(name.getCode().toString(), name.getDesc()))
                .collect(Collectors.toList());
    }
}
