package com.elitesland.cbpl.rosefinch.client.register.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2024/10/06
 */
@Data
@ApiModel("任务注册参数")
public class RosefinchSaveParamDTO implements Serializable {

    private static final long serialVersionUID = 2935538244723362529L;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "分组标签")
    private String taskTag;

    @ApiModelProperty(value = "定时任务名称")
    private String taskName;

    @ApiModelProperty(value = "定时任务编码")
    private String taskCode;

    @ApiModelProperty(value = "任务类型：1常规、2进度条、3导出、4反射")
    private Integer taskType;

    @ApiModelProperty(value = "类名")
    private String className;

    @ApiModelProperty(value = "方法名")
    private String method;

    @ApiModelProperty(value = "方法固定参数(JSON字符串)")
    private String methodArgs;

    @ApiModelProperty(value = "状态：0禁用；1启用；")
    private Integer status;

    @ApiModelProperty(value = "定时任务是否开启")
    private Integer scheduleFlag;

    @ApiModelProperty(value = "告警推送是否开启")
    private Integer warnFlag;

    @ApiModelProperty(value = "实例删除策略")
    private String deletionStrategy;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "自定义字段(JSON字符串)")
    private String customFields;
}
