package com.elitesland.cbpl.rosefinch.client.queue.producer.message;

import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2024/10/11
 */
@Data
public class TaskInfo implements Serializable {

    private static final long serialVersionUID = 410731966401400791L;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务编码
     */
    private String taskCode;

    /**
     * 任务类型 {@link RosefinchType}
     */
    private Integer taskType;

    /**
     * 类名
     */
    private String className;

    /**
     * 方法名
     */
    private String method;

    /**
     * 方法固定参数(JSON字符串)
     */
    private String methodArgs;

    /**
     * 告警推送是否开启
     */
    private Integer warnFlag;

    /**
     * 状态：0禁用；1启用；
     */
    private Integer status;
}
