package com.elitesland.cbpl.rosefinch.client.queue.producer.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务实例
 *
 * @author eric.hao
 * @since 2024/10/08
 */
@Data
@ApiModel("任务实例")
public class InstanceDTO implements Serializable {

	private static final long serialVersionUID = 1697784043493874556L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "任务ID")
	private Long masId;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "执行方式：AUTO自动执行；INVOKE手动执行；")
	private String runType;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "执行时间")
	private LocalDateTime executeTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "全局链路ID")
	private String globalTraceId;

	@ApiModelProperty(value = "日志链路ID")
	private String traceId;

	@ApiModelProperty(value = "调用传值(JSON字符串)")
	private String methodArgs;

	@ApiModelProperty(value = "总行数")
	private Integer totalCount;

	@ApiModelProperty(value = "成功行数")
	private Integer successCount;

	@ApiModelProperty(value = "失败行数")
	private Integer failCount;

	@ApiModelProperty(value = "文件下载路径")
	private String filePath;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "自定义字段(JSON字符串)")
	private String customFields;
}
