package com.elitesland.cbpl.rosefinch.client.queue.producer.message;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.dto.InstanceDTO;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/10/06
 */
@Data
public class TaskMessage implements Serializable {

    private static final long serialVersionUID = -8551299374342363621L;
    private static final Logger log = LoggerFactory.getLogger(TaskMessage.class);

    /**
     * 消息头
     */
    private TaskHeader header;

    /**
     * 消息体
     */
    private Object payload;

    /**
     * 消息初始化
     */
    public static TaskMessage withPayload(TaskInfo taskInfo) {
        return TaskMessage.withPayload(taskInfo, null);
    }

    /**
     * 消息初始化
     */
    public static TaskMessage withPayload(TaskInfo taskInfo, Object payload) {
        TaskMessage message = new TaskMessage();
        TaskHeader header = new TaskHeader();
        header.setMessageId(IdUtil.fastSimpleUUID());
        header.setTenantCode(TenantSpiUtil.currentTenantCode());
        header.setTaskInfo(taskInfo);
        message.setHeader(header);
        message.setPayload(payload);
        return message;
    }

    /**
     * 返回参数数组长度
     * <li>1. 如果payload==null，返回0</li>
     * <li>2. 按照CollUtil.size()的计算，返回数据长度</li>
     * <li>3. 非Array类型，长度返回1</li>
     */
    public int size() {
        try {
            return CollUtil.size(payload);
        } catch (IllegalArgumentException e) {
            // Unsupported object type
            log.warn(e.getMessage());
        }
        return 1;
    }

    // ======================== HEADER取值 ======================== //

    /**
     * 消息ID
     */
    @JsonIgnore
    public String getMessageId() {
        return header.getMessageId();
    }

    /**
     * MDC
     */
    @JsonIgnore
    public Map<String, String> getParentMdc() {
        return header.getParentMdc();
    }

    public void setParentMdc(Map<String, String> parentMdc) {
        header.setParentMdc(parentMdc);
    }

    /**
     * 租户编码
     */
    @JsonIgnore
    public String getTenantCode() {
        return header.getTenantCode();
    }

    /**
     * 任务ID
     */
    @JsonIgnore
    public Long getTaskId() {
        return header.getTaskInfo().getTaskId();
    }

    /**
     * 任务编码
     */
    @JsonIgnore
    public String getTaskCode() {
        return header.getTaskInfo().getTaskCode();
    }

    /**
     * 任务名称
     */
    @JsonIgnore
    public String getTaskName() {
        return header.getTaskInfo().getTaskName();
    }

    /**
     * 任务类型
     */
    @JsonIgnore
    public Integer getTaskType() {
        return header.getTaskInfo().getTaskType();
    }

    /**
     * 任务实例
     */
    @JsonIgnore
    public InstanceDTO getInstanceDTO() {
        return header.getInstanceDTO();
    }

    public void setInstanceDTO(InstanceDTO instanceDTO) {
        header.setInstanceDTO(instanceDTO);
    }

    /**
     * 任务实例ID
     */
    @JsonIgnore
    public Long getInstanceId() {
        return header.getInstanceDTO().getId();
    }

    /**
     * 告警推送是否开启
     */
    @JsonIgnore
    public boolean warnFlag() {
        Integer warnFlag = header.getTaskInfo().getWarnFlag();
        return warnFlag != null && warnFlag == 1;
    }
}
