package com.elitesland.cbpl.rosefinch.client.queue.producer;

import com.elitesland.cbpl.rosefinch.client.constant.RosefinchClientDomain;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.unicom.annotation.Unicom;

/**
 * 任务队列操作
 *
 * @author eric.hao
 * @version 0.2.1-SNAPSHOT
 * @since 2024/10/06
 */
@Unicom(domain = RosefinchClientDomain.ROSEFINCH, path = ProducerProxy.URI)
public interface ProducerProxy {

    String URI = RosefinchClientDomain.URI_PREFIX + "/queue";

    /**
     * 异步发送消息报文，给任务中心
     *
     * @param payload 消息报文
     * @return 任务实例ID
     */
    default Long send(TaskMessage payload) {
        return send(payload, "手动执行");
    }

    /**
     * 异步发送消息报文，给任务中心
     *
     * @param payload 消息报文
     * @param runType 执行方式
     * @return 任务实例ID
     */
    Long send(TaskMessage payload, String runType);

    /**
     * 立即终止实例
     *
     * @param taskCode   任务编码
     * @param instanceId 实例ID
     * @return 如果无法取消任务，则为false，通常是因为任务已正常完成；否则为true；
     */
    boolean stop(String taskCode, long instanceId);
}
