package com.elitesland.cbpl.rosefinch.client.register;

import com.elitesland.cbpl.rosefinch.client.constant.RosefinchClientDomain;
import com.elitesland.cbpl.rosefinch.client.register.dto.RosefinchSaveParamDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;

/**
 * 任务注册与修改
 *
 * @author eric.hao
 * @since 2024/10/06
 */
@Unicom(domain = RosefinchClientDomain.ROSEFINCH, path = RosefinchProxy.URI)
public interface RosefinchProxy {

    String URI = RosefinchClientDomain.URI_PREFIX + "/config";

    /**
     * 任务注册
     *
     * @param saveParamDTO 注册参数
     * @return 任务ID
     */
    Long create(RosefinchSaveParamDTO saveParamDTO);

    /**
     * 任务配置修改
     *
     * @param saveParamDTO 修改参数
     * @return 任务ID
     */
    Long update(RosefinchSaveParamDTO saveParamDTO);

    /**
     * 任务删除，谨慎使用
     * <li>1. 删除该任务的配置</li>
     * <li>2. 删除该任务的所有实例</li>
     * <li>3. 删除该任务的所有相关日志</li>
     * <li>4. 物理删除，不可撤回</li>
     *
     * @param taskId 任务ID
     * @return 是否删除成功
     */
    boolean delete(long taskId);
}
