package com.elitesland.cbpl.rosefinch.queue.rocketmq.producer;

import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.MDC;
import org.springframework.messaging.support.MessageBuilder;

/**
 * @author eric.hao
 * @since 2024/09/29
 */
@Slf4j
@RequiredArgsConstructor
public class RocketmqQueueProducer implements QueueHandlerService {

    private final RocketMQTemplate rocketmqTemplate;

    /**
     * @param payload 消息报文
     */
    @Override
    public void publish(TaskMessage payload) {
        String taskCode = payload.getTaskCode();
        payload.setParentMdc(MDC.getCopyOfContextMap());
        var message = MessageBuilder.withPayload(payload).build();
        rocketmqTemplate.asyncSend(RosefinchUtil.topicTags(taskCode), message, new SendCallback() {
            @Override
            public void onSuccess(SendResult sendResult) {
                LogUtil.info(taskCode, null, "[ROSEFINCH][ROCKETMQ] 任务(" + taskCode + ") 发布完成", null, null);
            }

            @Override
            public void onException(Throwable throwable) {
                // 消息发送失败，需要进行重试处理，可重新发送这条消息或持久化这条数据进行补偿处理。TODO 暂记录日志
                LogUtil.error(taskCode, null,
                        "[ROSEFINCH][ROCKETMQ] 任务(" + taskCode + ") 发布异常：",
                        null, throwable, null
                );
            }
        });
    }

    @Override
    public boolean stopImmediately(String instanceKey) {
        return false;
    }
}
