/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.queue.rocketmq.producer;

import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class RocketmqQueueProducer
implements QueueHandlerService {
    private static final Logger logger = LoggerFactory.getLogger(RocketmqQueueProducer.class);
    private final RocketMQTemplate rocketmqTemplate;

    public void publish(TaskMessage payload) {
        final String taskCode = payload.getTaskCode();
        payload.setParentMdc(MDC.getCopyOfContextMap());
        Message message = MessageBuilder.withPayload((Object)payload).build();
        this.rocketmqTemplate.asyncSend(RosefinchUtil.topicTags((String)taskCode), message, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                LogUtil.info((String)taskCode, null, (String)("[ROSEFINCH][ROCKETMQ] \u4efb\u52a1(" + taskCode + ") \u53d1\u5e03\u5b8c\u6210"), null, null);
            }

            public void onException(Throwable throwable) {
                LogUtil.error((String)taskCode, null, (String)("[ROSEFINCH][ROCKETMQ] \u4efb\u52a1(" + taskCode + ") \u53d1\u5e03\u5f02\u5e38\uff1a"), null, (Throwable)throwable, null);
            }
        });
    }

    public boolean stopImmediately(RosefinchInstanceDetailVO instance) {
        return false;
    }

    public RocketmqQueueProducer(RocketMQTemplate rocketmqTemplate) {
        this.rocketmqTemplate = rocketmqTemplate;
    }
}

