/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.queue.rocketmq.config;

import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.rocketmq.producer.RocketmqQueueProducer;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="cbpl.rosefinch", name={"enabled"}, havingValue="true")
public class RocketmqRosefinchAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RocketmqRosefinchAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="cbpl.rosefinch", name={"queue-strategy"}, havingValue="rocketmq")
    public QueueHandlerService disruptorQueueProducer(RocketMQTemplate rocketmqTemplate) {
        logger.info("[ROSEFINCH] Registry RocketmqQueueProducer.");
        return new RocketmqQueueProducer(rocketmqTemplate);
    }
}

