package com.elitesland.cbpl.rosefinch.queue.rocketmq.config;

import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.rocketmq.producer.RocketmqQueueProducer;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/09/29
 */
@Slf4j
@Configuration
@ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class RocketmqRosefinchAutoConfiguration {

    /**
     * 任务队列的发布与终止接口
     */
    @Bean
    @ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "queue-strategy", havingValue = "rocketmq")
    public QueueHandlerService disruptorQueueProducer(RocketMQTemplate rocketmqTemplate) {
        logger.info("[ROSEFINCH] Registry RocketmqQueueProducer.");
        return new RocketmqQueueProducer(rocketmqTemplate);
    }
}
