package com.elitesland.cbpl.rosefinch.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.entity.QRosefinchDetailDO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchDetailPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchDetailRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Component
@RequiredArgsConstructor
public class RosefinchDetailRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QRosefinchDetailDO Q_ROSEFINCH_DETAIL_DO = QRosefinchDetailDO.rosefinchDetailDO;

    private final QBean<RosefinchDetailRespVO> detailListVO = Projections.bean(
            RosefinchDetailRespVO.class,
            Q_ROSEFINCH_DETAIL_DO.id,
            Q_ROSEFINCH_DETAIL_DO.masId,
            Q_ROSEFINCH_DETAIL_DO.lineNo,
            Q_ROSEFINCH_DETAIL_DO.logStatus,
            Q_ROSEFINCH_DETAIL_DO.errorMsg,
            Q_ROSEFINCH_DETAIL_DO.startTime,
            Q_ROSEFINCH_DETAIL_DO.endTime
    );

    private Predicate where(RosefinchDetailPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_ROSEFINCH_DETAIL_DO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(paramVO.getMasId())) {
            predicates.add(Q_ROSEFINCH_DETAIL_DO.masId.eq(paramVO.getMasId()));
        }
        String logStatus = StringUtils.defaultIfBlank(paramVO.getLogStatus(), "E");
        predicates.add(Q_ROSEFINCH_DETAIL_DO.logStatus.eq(logStatus));
        return ExpressionUtils.allOf(predicates);
    }

    public long detailCountBy(RosefinchDetailPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Q_ROSEFINCH_DETAIL_DO.id)
                .from(Q_ROSEFINCH_DETAIL_DO);
        jpaQuery.where(this.where(paramVO));
        return jpaQuery.fetch().size();
    }

    public List<RosefinchDetailRespVO> detailPageBy(RosefinchDetailPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(detailListVO)
                .from(Q_ROSEFINCH_DETAIL_DO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, Q_ROSEFINCH_DETAIL_DO);
        jpaQuery.where(this.where(paramVO));
        jpaQuery.orderBy(Q_ROSEFINCH_DETAIL_DO.lineNo.asc());
        return jpaQuery.fetch();
    }
}
