/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.controller;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.rosefinch.service.RosefinchService;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchDetailPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchDetailRespVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchListRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f02\u6b65\u6279\u5904\u7406"})
@ApiSupport(author="eric.hao", order=1)
@RestController
@RequestMapping(value={"/rosefinch"}, produces={"application/json"})
public class RosefinchController {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchController.class);
    private final RosefinchService rosefinchService;

    @ApiOperation(value="\u5f02\u6b65\u6279\u5904\u7406 - \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public ApiResult<PagingVO<RosefinchListRespVO>> list(@RequestBody RosefinchPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-ROSEFINCH] page list, param={}", (Object)paramVO);
            return ApiResult.ok(this.rosefinchService.rosefinchPageBy(paramVO));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5f02\u6b65\u6279\u5904\u7406 - \u660e\u7ec6\u67e5\u8be2")
    @PostMapping(value={"/detail"})
    public ApiResult<PagingVO<RosefinchDetailRespVO>> detail(@RequestBody @Validated RosefinchDetailPageParamVO paramVO) {
        try {
            logger.debug("[CBPL-ROSEFINCH] query detail param={}", (Object)paramVO);
            return ApiResult.ok(this.rosefinchService.rosefinchDetails(paramVO));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public RosefinchController(RosefinchService rosefinchService) {
        this.rosefinchService = rosefinchService;
    }
}

