package com.elitesland.cbpl.rosefinch.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Entity
@Table(name = "cbpl_rosefinch_detail")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_rosefinch_detail", comment = "批处理日志明细")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_rosefinch_detail", description = "批处理日志明细")
public class RosefinchDetailDO extends BaseModel implements Serializable {

    @Comment(value = "行号")
    @Column()
    private Integer lineNo;

    @Comment(value = "主表id")
    @Column()
    private Long masId;

    @Comment(value = "日志行状态")
    @Column()
    private String logStatus;

    @Comment(value = "错误信息")
    @Column()
    private String errorMsg;

    @Comment(value = "开始时间")
    @Column()
    private LocalDateTime startTime;

    @Comment(value = "结束时间")
    @Column()
    private LocalDateTime endTime;
}
