package com.elitesland.cbpl.rosefinch.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Entity
@Table(name = "cbpl_rosefinch_log")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cbpl_rosefinch_log", comment = "批处理日志表")
@Data
@Accessors(chain = true)
@ApiModel(value = "cbpl_rosefinch_log", description = "批处理日志表")
public class RosefinchLogDO extends BaseModel implements Serializable {

    @Comment(value = "日志记录编码")
    @Column()
    private String logNo;

    @Comment(value = "日志状态")
    @Column()
    private String logStatus;

    @Comment(value = "日志类型")
    @Column()
    private String logType;

    @Comment(value = "成功记录数")
    @Column()
    private Integer successCount;

    @Comment(value = "失败记录数")
    @Column()
    private Integer failCount;

    @Comment(value = "记录总数")
    @Column()
    private Integer totalCount;

    @Comment(value = "结束时间")
    @Column()
    private LocalDateTime endTime;
}
