package com.elitesland.cbpl.rosefinch.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.rosefinch.entity.RosefinchDetailDO;
import com.elitesland.cbpl.rosefinch.entity.RosefinchLogDO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchDetailPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchDetailRespVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchListRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
public interface RosefinchService {

    /**
     * 批处理 - 日志初始化
     *
     * @param asyncType  处理类型
     * @param totalCount 记录总数
     * @return 批处理日志
     */
    RosefinchLogDO init(String asyncType, int totalCount);

    /**
     * 批处理 - 日志保存
     *
     * @param headLog       表头日志
     * @param detailLogList 明细日志
     */
    void save(RosefinchLogDO headLog, List<RosefinchDetailDO> detailLogList);

    /**
     * 批处理日志 - 分页查询
     *
     * @param paramVO 分页参数
     * @return 分页数据
     */
    PagingVO<RosefinchListRespVO> rosefinchPageBy(RosefinchPageParamVO paramVO);

    /**
     * 批处理日志 - 明细查询
     *
     * @param paramVO 分页参数
     * @return 明细信息
     */
    PagingVO<RosefinchDetailRespVO> rosefinchDetails(RosefinchDetailPageParamVO paramVO);
}
