package com.elitesland.cbpl.rosefinch.config;

import com.elitesland.cbpl.rosefinch.constant.QueueStrategy;
import com.elitesland.cbpl.rosefinch.constant.TenantIsolateStrategy;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/08/05
 */
@Data
@ConfigurationProperties(prefix = ROSEFINCH_CONFIG_PREFIX)
public class RosefinchProperties implements InitializingBean {

    public static final String ROSEFINCH_CONFIG_PREFIX = "cbpl.rosefinch";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 队列策略
     * {@link QueueStrategy}
     */
    private String queueStrategy = "default";

    /**
     * 租户隔离策略，默认不隔离
     */
    private TenantIsolateStrategy tenantIsolateStrategy = TenantIsolateStrategy.NONE;

    public static boolean ROSEFINCH_ENABLED;
    public static TenantIsolateStrategy TENANT_ISOLATE_STRATEGY;

    @Override
    public void afterPropertiesSet() throws Exception {
        ROSEFINCH_ENABLED = enabled;
        TENANT_ISOLATE_STRATEGY = tenantIsolateStrategy;
    }
}
