package com.elitesland.cbpl.rosefinch.constant;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Getter
public enum InstanceStatus {

    /**
     * 实例状态
     */
    READY("就绪"),
    RUNNING("进行中"),
    COMPLETE("已完成"),
    INTERRUPT("异常中断"),
    STOP("手动终止"),
    SHUTDOWN("服务关停"),
    ;

    private final String desc;

    public String getCode() {
        return this.name();
    }

    InstanceStatus(String desc) {
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (InstanceStatus status : InstanceStatus.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }

    public static List<EnumValues> enumValues() {
        return Arrays.stream(InstanceStatus.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
    }
}
