package com.elitesland.cbpl.rosefinch.data.controller;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
@Slf4j
@Api(tags = "任务实例表")
@RestController
@RequestMapping("/rosefinch/instance")
@AllArgsConstructor
public class RosefinchInstanceController {

    private final RosefinchInstanceService rosefinchInstanceService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/list")
    public HttpResult<PagingVO<RosefinchInstancePagingVO>> list(@RequestBody RosefinchInstancePagingParamVO query) {
        logger.info("[Rosefinch][Instance] query paging param = {}", query);
        return HttpResult.ok(rosefinchInstanceService.rosefinchInstancePageBy(query));
    }
}
