package com.elitesland.cbpl.rosefinch.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
@Component
@RequiredArgsConstructor
public class RosefinchConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QRosefinchConfigDO rosefinchConfigDO = QRosefinchConfigDO.rosefinchConfigDO;

    private Predicate pagingWhere(RosefinchConfigPagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(rosefinchConfigDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getTaskCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getTaskCodeName());
            predicates.add(rosefinchConfigDO.taskCode.eq(query.getTaskCodeName())
                    .or(rosefinchConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank(query.getTaskName())) {
            predicates.add(rosefinchConfigDO.taskName.eq(query.getTaskName()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(rosefinchConfigDO.taskCode.eq(query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull(query.getStatus())) {
            predicates.add(rosefinchConfigDO.status.eq(query.getStatus()));
        }
        // tags不为空，则按条件查询
        if (StrUtil.isNotBlank(query.getTags())) {
            predicates.add(rosefinchConfigDO.taskTag.eq(query.getTags()));
        }
        // 为空时，默认仅查询为null的数据
        else {
            predicates.add(rosefinchConfigDO.taskTag.isNull());
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long rosefinchConfigCountBy(RosefinchConfigPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(rosefinchConfigDO.id)
                .from(rosefinchConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<RosefinchConfigDO> rosefinchConfigPageBy(RosefinchConfigPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(rosefinchConfigDO)
                .from(rosefinchConfigDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, rosefinchConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(rosefinchConfigDO)
                .set(rosefinchConfigDO.deleteFlag, 1)
                .where(rosefinchConfigDO.id.in(ids));
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    public long updateStatus(Long id, int status) {
        JPAUpdateClause update = jpaQueryFactory.update(rosefinchConfigDO)
                .set(rosefinchConfigDO.status, status)
                .where(rosefinchConfigDO.id.eq(id));
        return update.execute();
    }

    /**
     * 任务编码是否存在
     */
    public boolean existsByCode(Long taskId, String taskCode) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(rosefinchConfigDO.taskCode.eq(taskCode));
        if (ObjectUtil.isNotNull(taskId)) {
            predicates.add(rosefinchConfigDO.id.ne(taskId));
        }
        var jpaQuery = jpaQueryFactory.select(rosefinchConfigDO.id)
                .from(rosefinchConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }
}
