package com.elitesland.cbpl.rosefinch.data.service;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
public interface RosefinchConfigService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<RosefinchConfigPagingVO> rosefinchConfigPageBy(RosefinchConfigPagingParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    RosefinchConfigDetailVO rosefinchConfigById(Long id);

    /**
     * 明细查询
     *
     * @param taskCode 任务编码
     * @return 明细数据
     */
    TaskRequestParam rosefinchConfigByCode(String taskCode);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(RosefinchConfigSaveParamVO saveParam);

    /**
     * 启用
     *
     * @param id 业务单据ID
     */
    void active(Long id);

    /**
     * 禁用
     *
     * @param id 业务单据ID
     */
    void inactive(Long id);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    void delete(List<Long> ids);

    /**
     * 立即执行一次
     *
     * @param taskCode 任务编码
     */
    void execute(String taskCode);
}
