/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.config;

import com.elitesland.cbpl.rosefinch.config.RosefinchProperties;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.producer.DefaultQueueProducer;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableDynamicTp
@Configuration
@EnableConfigurationProperties(value={RosefinchProperties.class})
@ConditionalOnProperty(prefix="cbpl.rosefinch", name={"enabled"}, havingValue="true")
public class RosefinchAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="cbpl.rosefinch", name={"queue-strategy"}, havingValue="default", matchIfMissing=true)
    public QueueHandlerService defaultQueueProducer() {
        logger.info("[ROSEFINCH] Registry DefaultQueueProducer.");
        return new DefaultQueueProducer();
    }

    @Bean
    public QueueProxy queueProxy(QueueHandlerService handlerService) {
        logger.info("[ROSEFINCH] Registry QueueProxy.");
        return new QueueProxy(handlerService);
    }
}

