/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchInstanceDO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class RosefinchInstanceRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QRosefinchConfigDO rosefinchConfigDO = QRosefinchConfigDO.rosefinchConfigDO;
    private static final QRosefinchInstanceDO rosefinchInstanceDO = QRosefinchInstanceDO.rosefinchInstanceDO;
    private final QBean<RosefinchInstancePagingVO> rosefinchInstancePagingVO;
    private final QBean<RosefinchInstanceRespVO> rosefinchInstanceVO;

    private Predicate pagingWhere(RosefinchInstancePagingParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            String likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getInstanceStatus())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus.eq((Object)query.getInstanceStatus()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStartTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime.eq((Object)query.getStartTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getEndTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime.eq((Object)query.getEndTime()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage.eq((Object)query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTraceId())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId.eq((Object)query.getTraceId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTags())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchConfigDO.taskTag.eq((Object)query.getTags()));
        } else {
            predicates.add(RosefinchInstanceRepoProc.rosefinchConfigDO.taskTag.isNull());
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long rosefinchInstanceCountBy(RosefinchInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(RosefinchInstanceRepoProc.rosefinchInstanceDO.id).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<RosefinchInstancePagingVO> rosefinchInstancePageBy(RosefinchInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.rosefinchInstancePagingVO).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, rosefinchInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public RosefinchInstanceRespVO findById(Long instanceId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag.eq((Object)0));
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.id.eq((Object)instanceId));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.rosefinchInstanceVO).from((EntityPath)rosefinchInstanceDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)RosefinchInstanceRepoProc.rosefinchConfigDO.id.eq(RosefinchInstanceRepoProc.rosefinchInstanceDO.masId));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return (RosefinchInstanceRespVO)jpaQuery.fetchOne();
    }

    public long delete(RosefinchInstanceDeleteParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.eq((Object)paramVO.getTaskCode()));
        predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus.in(paramVO.getInstanceStatus()));
        if (ObjectUtil.isNotNull((Object)paramVO.getBeforeTime())) {
            predicates.add(RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime.lt((Comparable)paramVO.getBeforeTime()));
        }
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)rosefinchInstanceDO);
        delete.where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public long update(RosefinchInstanceSaveParamVO saveParam) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)rosefinchInstanceDO).set(RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, (Object)saveParam.getExecuteTime()).where(new Predicate[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id.eq((Object)saveParam.getId())});
        if (StrUtil.isNotBlank((CharSequence)saveParam.getTraceId())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, (Object)saveParam.getTraceId());
        }
        if (ObjectUtil.isNotNull((Object)saveParam.getEndTime())) {
            update.set(RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, (Object)saveParam.getEndTime());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getErrorMessage())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, (Object)saveParam.getErrorMessage());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getInstanceStatus())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, (Object)saveParam.getInstanceStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)saveParam.getRemark())) {
            update.set((Path)RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, (Object)saveParam.getRemark());
        }
        return update.execute();
    }

    public RosefinchInstanceRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.rosefinchInstancePagingVO = Projections.bean(RosefinchInstancePagingVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id, RosefinchInstanceRepoProc.rosefinchInstanceDO.masId, RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskCode).as("taskCode"), RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskName).as("taskName"), RosefinchInstanceRepoProc.rosefinchInstanceDO.runType, RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.customFields, RosefinchInstanceRepoProc.rosefinchInstanceDO.tenantId, RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, RosefinchInstanceRepoProc.rosefinchInstanceDO.createUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.creator, RosefinchInstanceRepoProc.rosefinchInstanceDO.createTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.updater, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag});
        this.rosefinchInstanceVO = Projections.bean(RosefinchInstanceRespVO.class, (Expression[])new Expression[]{RosefinchInstanceRepoProc.rosefinchInstanceDO.id, RosefinchInstanceRepoProc.rosefinchInstanceDO.masId, RosefinchInstanceRepoProc.rosefinchInstanceDO.taskCode.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskCode).as("taskCode"), RosefinchInstanceRepoProc.rosefinchInstanceDO.taskName.coalesce((Expression)RosefinchInstanceRepoProc.rosefinchConfigDO.taskName).as("taskName"), RosefinchInstanceRepoProc.rosefinchInstanceDO.runType, RosefinchInstanceRepoProc.rosefinchInstanceDO.instanceStatus, RosefinchInstanceRepoProc.rosefinchInstanceDO.startTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.executeTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.endTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.errorMessage, RosefinchInstanceRepoProc.rosefinchInstanceDO.traceId, RosefinchInstanceRepoProc.rosefinchInstanceDO.customFields, RosefinchInstanceRepoProc.rosefinchInstanceDO.tenantId, RosefinchInstanceRepoProc.rosefinchInstanceDO.remark, RosefinchInstanceRepoProc.rosefinchInstanceDO.createUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.creator, RosefinchInstanceRepoProc.rosefinchInstanceDO.createTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyUserId, RosefinchInstanceRepoProc.rosefinchInstanceDO.updater, RosefinchInstanceRepoProc.rosefinchInstanceDO.modifyTime, RosefinchInstanceRepoProc.rosefinchInstanceDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

