/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.constant.ActiveStatus;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepo;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepoProc;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigPagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigPagingVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RosefinchConfigServiceImpl
implements RosefinchConfigService {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchConfigServiceImpl.class);
    private final RosefinchConfigRepo rosefinchConfigRepo;
    private final RosefinchConfigRepoProc rosefinchConfigRepoProc;
    @Autowired(required=false)
    private QueueProxy queueProxy;

    @Override
    public PagingVO<RosefinchConfigPagingVO> rosefinchConfigPageBy(RosefinchConfigPagingParamVO query) {
        long count = this.rosefinchConfigRepoProc.rosefinchConfigCountBy(query);
        if (count > 0L) {
            List<RosefinchConfigDO> list = this.rosefinchConfigRepoProc.rosefinchConfigPageBy(query);
            return new PagingVO(count, RosefinchConfigConvert.INSTANCE.doToPageVO(list));
        }
        return new PagingVO();
    }

    @Override
    public RosefinchConfigDetailVO rosefinchConfigById(Long id) {
        Optional rosefinchConfigDO = this.rosefinchConfigRepo.findById(id);
        if (rosefinchConfigDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return RosefinchConfigConvert.INSTANCE.doToVO((RosefinchConfigDO)rosefinchConfigDO.get());
    }

    @Override
    public TaskRequestParam rosefinchConfigByCode(String taskCode) {
        Optional<RosefinchConfigDO> rosefinchConfigDO = this.rosefinchConfigRepo.findByTaskCode(taskCode);
        if (rosefinchConfigDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        return RosefinchConfigConvert.INSTANCE.doToRequest(rosefinchConfigDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RosefinchConfigSaveParamVO saveParam) {
        boolean exists = this.rosefinchConfigRepoProc.existsByCode(saveParam.getId(), saveParam.getTaskCode());
        Assert.isFalse((boolean)exists, (String)"\u4efb\u52a1\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (saveParam.isNew()) {
            RosefinchConfigDO rosefinchConfigDO = RosefinchConfigConvert.INSTANCE.saveParamToDO(saveParam);
            this.rosefinchConfigRepo.save(rosefinchConfigDO);
            return rosefinchConfigDO.getId();
        }
        Optional rosefinchConfigDO = this.rosefinchConfigRepo.findById(saveParam.getId());
        if (rosefinchConfigDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        RosefinchConfigDO rosefinchConfig = (RosefinchConfigDO)rosefinchConfigDO.get();
        RosefinchConfigConvert.INSTANCE.saveParamMergeToDO(saveParam, rosefinchConfig);
        this.rosefinchConfigRepo.save(rosefinchConfig);
        return rosefinchConfig.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void active(Long id) {
        this.rosefinchConfigRepoProc.updateStatus(id, ActiveStatus.ACTIVE.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void inactive(Long id) {
        this.rosefinchConfigRepoProc.updateStatus(id, ActiveStatus.INACTIVE.getCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<Long> ids) {
        this.rosefinchConfigRepo.deleteAllById(ids);
    }

    @Override
    public void execute(String taskCode) {
        if (ObjectUtil.isNull((Object)this.queueProxy)) {
            throw new RuntimeException("Rosefinch\u6a21\u5757\u672a\u5f00\u542f");
        }
        try {
            this.queueProxy.runImmediately(this.rosefinchConfigByCode(taskCode));
        }
        catch (RuntimeException e) {
            throw PhoenixException.unexpected((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u4efb\u52a1\u6267\u884c\u5f02\u5e38: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            throw PhoenixException.unexpected((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
    }

    public RosefinchConfigServiceImpl(RosefinchConfigRepo rosefinchConfigRepo, RosefinchConfigRepoProc rosefinchConfigRepoProc) {
        this.rosefinchConfigRepo = rosefinchConfigRepo;
        this.rosefinchConfigRepoProc = rosefinchConfigRepoProc;
    }
}

