package com.elitesland.cbpl.rosefinch.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.15-SNAPSHOT
 * @since 2024/08/06
 */
@Getter
public enum SuccessTag {

    /**
     * 状态
     */
    SUCCESS(true, "成功"),
    FAILED(false, "失败"),
    ;

    private final Boolean code;
    private final String desc;

    SuccessTag(Boolean code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(boolean code) {
        if (ObjectUtil.isNull(code)) return null;
        for (SuccessTag status : SuccessTag.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return FAILED.getDesc();
    }
}
