package com.elitesland.cbpl.rosefinch.data.service;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.tool.db.PagingVO;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
public interface RosefinchInstanceService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<RosefinchInstancePagingVO> rosefinchInstancePageBy(RosefinchInstancePagingParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    RosefinchInstanceDetailVO rosefinchInstanceById(Long id);

    /**
     * 更新
     *
     * @param saveParam 更新参数
     * @return 业务单据ID
     */
    void update(RosefinchInstanceSaveParamVO saveParam);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(RosefinchInstanceSaveParamVO saveParam);

    /**
     * 删除实例日志
     *
     * @param paramVO 删除参数
     * @param source  调用方式：AUTO定时任务执行；INVOKE手动调用；
     */
    long deleteInstance(RosefinchInstanceDeleteParamVO paramVO, String source);
}
