package com.elitesland.cbpl.rosefinch.data.service.impl;

import com.elitesland.cbpl.rosefinch.data.convert.RosefinchInstanceConvert;
import com.elitesland.cbpl.rosefinch.data.entity.RosefinchInstanceDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchInstanceRepo;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchInstanceRepoProc;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstancePagingParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstancePagingVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceRespVO;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RosefinchInstanceServiceImpl implements RosefinchInstanceService {

    private final RosefinchInstanceRepo rosefinchInstanceRepo;
    private final RosefinchInstanceRepoProc rosefinchInstanceRepoProc;

    @Override
    public PagingVO<RosefinchInstancePagingVO> rosefinchInstancePageBy(RosefinchInstancePagingParamVO query) {
        long count = rosefinchInstanceRepoProc.rosefinchInstanceCountBy(query);
        if (count > 0) {
            var list = rosefinchInstanceRepoProc.rosefinchInstancePageBy(query);
            return new PagingVO<>(count, list);
        }
        return new PagingVO<>();
    }

    @Override
    public RosefinchInstanceDetailVO rosefinchInstanceById(Long id) {
        RosefinchInstanceRespVO instanceVO = rosefinchInstanceRepoProc.findById(id);
        return RosefinchInstanceConvert.INSTANCE.respToVO(instanceVO);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(RosefinchInstanceSaveParamVO saveParam) {
        Assert.notNull(saveParam.getId(), "Missing Primary Key");
        rosefinchInstanceRepoProc.update(saveParam);
    }

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
    @Override
    public Long save(RosefinchInstanceSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            RosefinchInstanceDO rosefinchInstanceDO = RosefinchInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            rosefinchInstanceRepo.save(rosefinchInstanceDO);
            return rosefinchInstanceDO.getId();
        }
        // 修改
        else {
            Optional<RosefinchInstanceDO> rosefinchInstanceDO = rosefinchInstanceRepo.findById(saveParam.getId());
            if (rosefinchInstanceDO.isEmpty()) {
                throw PhoenixException.unexpected("Not Found Data");
            }
            RosefinchInstanceDO rosefinchInstance = rosefinchInstanceDO.get();
            RosefinchInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, rosefinchInstance);
            rosefinchInstanceRepo.save(rosefinchInstance);
            return rosefinchInstance.getId();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long deleteInstance(RosefinchInstanceDeleteParamVO paramVO, String source) {
        if (!paramVO.isEmpty()) {
            logger.debug("[ROSEFINCH] {} delete instance: {}", source, BeanUtils.toJsonStr(paramVO));
            return rosefinchInstanceRepoProc.delete(paramVO);
        }
        return 0L;
    }
}
