package com.elitesland.cbpl.rosefinch.queue.producer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * @author eric.hao
 * @since 2024/06/24
 */
@Slf4j
@RequiredArgsConstructor
public class DefaultQueueProducer implements QueueHandlerService {

    /**
     * 同步执行
     */
    @Override
    public void publish(RosefinchInstanceSaveParamVO instance, Runnable runnable) {
        try {
            LogUtil.info("[ROSEFINCH][DEFAULT] 任务发布：");
            QueueProxy handler = SpringUtil.getBean(QueueProxy.class);
            handler.execute(instance, runnable);
        } catch (NoSuchBeanDefinitionException e) {
            LogUtil.error("[ROSEFINCH][DEFAULT] 任务(" + instance.getTaskCode() + ") 处理异常：", e);
        }
    }

    @Override
    public boolean stopImmediately(String instanceKey) {
        return false;
    }
}
