create table sys_rosefinch_config
(
    id                bigint not null comment '主键' primary key,
    task_name         varchar(64) null comment '定时任务名称',
    task_code         varchar(64) null comment '定时任务编码',
    class_name        varchar(256) null comment '类名',
    method            varchar(256) null comment '方法名',
    method_args       text null comment '方法固定参数(JSON字符串)',
    task_tag          varchar(64) null comment '分组标签',
    status            int    default 0 null comment '状态：0禁用；1启用；',
    queue_strategy    int    default 0 null comment '队列策略',
    deletion_strategy varchar(2) null comment '实例删除策略',
    tenant_id         bigint default -1 null comment '租户ID',
    remark            varchar(255) null comment '备注',
    create_user_id    bigint null comment '记录创建者ID',
    creator           varchar(255) null comment '记录创建者',
    create_time       datetime(6) null comment '记录创建时间',
    modify_user_id    bigint null comment '记录最后更新者ID',
    updater           varchar(255) null comment '记录最后更新者',
    modify_time       datetime(6) null comment '记录最后更新时间',
    delete_flag       int    default 0 null comment '删除标记'
) comment='任务配置表';

create table sys_rosefinch_instance
(
    id              bigint not null comment '主键' primary key,
    mas_id          bigint null comment '任务ID',
    task_name       varchar(64) null comment '定时任务名称',
    task_code       varchar(64) null comment '定时任务编码',
    run_type        varchar(8) null comment '执行方式：AUTO自动执行；INVOKE手动执行；',
    instance_status varchar(16) null comment '日志行状态',
    method_args     text null comment '调用传值(JSON字符串)',
    start_time      datetime(6) null comment '开始时间',
    execute_time    datetime(6) null comment '执行时间',
    end_time        datetime(6) null comment '结束时间',
    error_message   varchar(255) null comment '错误日志',
    trace_id        varchar(64) null comment '日志链路ID',
    custom_fields   text null comment '自定义字段(JSON字符串)',
    tenant_id       bigint default -1 null comment '租户ID',
    remark          varchar(255) null comment '备注',
    create_user_id  bigint null comment '记录创建者ID',
    creator         varchar(255) null comment '记录创建者',
    create_time     datetime(6) null comment '记录创建时间',
    modify_user_id  bigint null comment '记录最后更新者ID',
    updater         varchar(255) null comment '记录最后更新者',
    modify_time     datetime(6) null comment '记录最后更新时间',
    delete_flag     int    default 0 null comment '删除标记'
) comment='任务实例表';