package com.elitesland.cbpl.dynamictp.domain;

import com.elitesland.cbpl.dynamictp.util.DtpVm;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/08/19
 */
@Data
public class TpProperty {

    /**
     * 线程池名称，必填
     */
    private String threadPoolName;

    /**
     * 线程名称前缀，必填
     */
    private String threadPrefix;

    /**
     * 核心线程数，默认2
     */
    private int corePoolSize = 2;

    /**
     * 最大线程数，默认cpu核数
     */
    private int maximumPoolSize = DtpVm.processors();

    /**
     * 队列容量，默认1024
     */
    private int queueCapacity = 1024;

    /**
     * <li>拒绝策略：默认`AbortPolicy`</li>
     */
    private String rejectPolicy = DtpVm.rejectPolicy();
}
