package com.elitesland.cbpl.dynamictp.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.dynamictp.service.DtpConstService;

/**
 * @author eric.hao
 * @since 2024/08/19
 */
public class DtpVm {

    private static DtpConstService dtpConstService;

    private static DtpConstService getDtpConstService() {
        if (dtpConstService == null) {
            dtpConstService = SpringUtil.getBean(DtpConstService.class);
        }
        return dtpConstService;
    }

    /**
     * 默认cpu核数
     */
    public static int processors() {
        return getDtpConstService().processors();
    }

    /**
     * 默认拒绝策略
     */
    public static String rejectPolicy() {
        return getDtpConstService().rejectPolicy();
    }
}
