package com.elitesland.cbpl.dynamictp.vm.v107.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtp.core.DtpRegistry;
import com.dtp.core.support.ThreadPoolBuilder;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.elitesland.cbpl.dynamictp.domain.TpProperty;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author eric.hao
 * @since 2024/08/19
 */
@Slf4j
@RequiredArgsConstructor
public class Dtp107Service implements DtpService<DtpExecutor> {

    @Override
    public <T extends TpProperty> DtpExecutor createDtpExecutor(T property) {
        return ThreadPoolBuilder.newBuilder()
                .threadPoolName(property.getThreadPoolName())
                .threadFactory(property.getThreadPrefix())
                .corePoolSize(property.getCorePoolSize())
                .maximumPoolSize(property.getMaximumPoolSize())
                .queueCapacity(property.getQueueCapacity())
                .rejectedExecutionHandler(property.getRejectPolicy())
                .buildDynamic();
    }

    @Override
    public <T extends TpProperty> ScheduledExecutorService createScheduledExecutor(T property) {
        return new ScheduledThreadPoolExecutor(
                property.getCorePoolSize(),
                new NamedThreadFactory(property.getThreadPrefix()),
                // todo 暂定
                new ThreadPoolExecutor.AbortPolicy()
        );
    }

    @Override
    public <T extends TpProperty> DtpExecutor getTaskExecutor(T property) {
        // 1. 存在任务线程池
        if (ObjectUtil.isNotNull(property)) {
            // 2. 已创建过线程池
            if (DtpRegistry.listAllDtpNames().contains(property.getThreadPoolName())) {
                return DtpRegistry.getDtpExecutor(property.getThreadPoolName());
            }
            // 3. 未创建，创建个新的线程池【适用于处理io密集型任务场景】
            return ThreadPoolBuilder.newBuilder()
                    .threadPoolName(property.getThreadPoolName())
                    .threadFactory(StrUtil.blankToDefault(property.getThreadPrefix(), property.getThreadPoolName()))
                    .corePoolSize(property.getCorePoolSize())
                    .maximumPoolSize(property.getMaximumPoolSize())
                    .queueCapacity(property.getQueueCapacity())
                    .rejectedExecutionHandler(property.getRejectPolicy())
                    .buildDynamic();
        }
        // 4. 返回任务线程池
        return DtpRegistry.getDtpExecutor(property.getThreadPoolName());
    }
}
