package com.elitesland.cbpl.dynamictp.vm.v117.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.dynamictp.domain.TpProperty;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;

import java.util.concurrent.ScheduledExecutorService;

/**
 * @author eric.hao
 * @since 2024/08/19
 */
@Slf4j
@RequiredArgsConstructor
public class Dtp117Service implements DtpService<DtpExecutor> {

    @Override
    public <T extends TpProperty> DtpExecutor createDtpExecutor(T property) {
        return ThreadPoolBuilder.newBuilder()
                .threadPoolName(property.getThreadPoolName())
                .threadFactory(property.getThreadPrefix())
                .corePoolSize(property.getCorePoolSize())
                .maximumPoolSize(property.getMaximumPoolSize())
                .queueCapacity(property.getQueueCapacity())
                .rejectedExecutionHandler(property.getRejectPolicy())
                .eager()
                .buildDynamic();
    }

    @Override
    public <T extends TpProperty> ScheduledExecutorService createScheduledExecutor(T property) {
        return ThreadPoolBuilder.newBuilder()
                .threadPoolName(property.getThreadPoolName())
                .threadFactory(property.getThreadPrefix())
                .corePoolSize(property.getCorePoolSize())
                .maximumPoolSize(property.getMaximumPoolSize())
                .queueCapacity(property.getQueueCapacity())
                .rejectedExecutionHandler(property.getRejectPolicy())
                .buildScheduled();
    }

    @Override
    public <T extends TpProperty> DtpExecutor getTaskExecutor(T property) {
        // 1. 存在任务线程池
        if (ObjectUtil.isNotNull(property)) {
            // 2. 已创建过线程池
            if (DtpRegistry.getAllExecutorNames().contains(property.getThreadPoolName())) {
                return DtpRegistry.getDtpExecutor(property.getThreadPoolName());
            }
            // 3. 未创建，创建个新的线程池【适用于处理io密集型任务场景】
            return ThreadPoolBuilder.newBuilder()
                    .threadPoolName(property.getThreadPoolName())
                    .threadFactory(StrUtil.blankToDefault(property.getThreadPrefix(), property.getThreadPoolName()))
                    .corePoolSize(property.getCorePoolSize())
                    .maximumPoolSize(property.getMaximumPoolSize())
                    .queueCapacity(property.getQueueCapacity())
                    .rejectedExecutionHandler(property.getRejectPolicy())
                    .eager()
                    .buildDynamic();
        }
        // 4. 返回任务线程池
        return DtpRegistry.getDtpExecutor(property.getThreadPoolName());
    }
}
