package com.elitesland.cbpl.rosefinch.config;

import com.elitesland.cbpl.dynamictp.service.DtpConstService;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import com.elitesland.cbpl.dynamictp.vm.v107.service.Dtp107Service;
import com.elitesland.cbpl.dynamictp.vm.v107.service.DtpConst107Service;
import com.elitesland.cbpl.dynamictp.vm.v117.service.Dtp117Service;
import com.elitesland.cbpl.dynamictp.vm.v117.service.DtpConst117Service;
import com.elitesland.cbpl.rosefinch.constant.DynamicConstant;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.producer.DefaultQueueProducer;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/08/05
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(RosefinchProperties.class)
@ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class RosefinchAutoConfiguration {

    /**
     * 任务队列的发布与终止接口
     */
    @Bean
    @ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "queue-strategy", havingValue = "default", matchIfMissing = true)
    public QueueHandlerService defaultQueueProducer() {
        logger.info("[ROSEFINCH] Registry DefaultQueueProducer.");
        return new DefaultQueueProducer();
    }

    /**
     * 任务调度的工具类
     */
    @Bean
    public QueueProxy queueProxy(QueueHandlerService handlerService) {
        logger.info("[ROSEFINCH] Registry QueueProxy.");
        return new QueueProxy(handlerService);
    }

    /**
     * 新版本
     */
    @org.dromara.dynamictp.core.spring.EnableDynamicTp
    @ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "version", havingValue = DynamicConstant.DYNAMIC_117, matchIfMissing = true)
    static class EnableDtp117 {

        @Bean
        public DtpService<org.dromara.dynamictp.core.executor.DtpExecutor> dtpService() {
            logger.info("[ROSEFINCH] Load DynamicTp v1.1.7.");
            return new Dtp117Service();
        }

        @Bean
        public DtpConstService dtpConstService() {
            return new DtpConst117Service();
        }
    }

    /**
     * 老版本
     */
    @com.dtp.core.spring.EnableDynamicTp
    @ConditionalOnProperty(prefix = ROSEFINCH_CONFIG_PREFIX, name = "version", havingValue = DynamicConstant.DYNAMIC_107)
    static class EnableDtp107 {

        @Bean
        public DtpService<com.dtp.core.thread.DtpExecutor> dtpService() {
            logger.info("[ROSEFINCH] Load DynamicTp v1.0.7.");
            return new Dtp107Service();
        }

        @Bean
        public DtpConstService dtpConstService() {
            return new DtpConst107Service();
        }
    }
}
