package com.elitesland.cbpl.rosefinch.data.controller;

import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.rosefinch.enums.InstanceStatus;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/07
 */
@Slf4j
@Api(tags = "任务参数接口")
@RestController
@RequestMapping("/rosefinch/common")
@AllArgsConstructor
public class RosefinchCommonController {

    @ApiOperation(value = "实例状态")
    @GetMapping(value = "/instance/status")
    public HttpResult<List<EnumValues>> status() {
        return HttpResult.ok(InstanceStatus.enumValues());
    }
}
