package com.elitesland.cbpl.rosefinch.data.vo.param;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 任务配置表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@ApiModel("任务配置表")
public class RosefinchConfigSaveParamVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "方法固定参数(JSON字符串)")
	private String methodArgs;

	@ApiModelProperty(value = "分组标签")
	private String taskTag;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@ApiModelProperty(value = "队列策略")
	private Integer queueStrategy;

	@ApiModelProperty(value = "实例删除策略")
	private String deletionStrategy;

	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
