package com.elitesland.cbpl.rosefinch.data.vo.resp;

import com.elitesland.cbpl.rosefinch.enums.InstanceStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 任务实例表
 *
 * @author eric.hao
 * @since 2024/08/06
 */
@Data
@ApiModel("任务实例表")
public class RosefinchInstanceDetailVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "任务ID")
	private Long masId;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "执行方式：AUTO自动执行；INVOKE手动执行；")
	private String runType;

	@ApiModelProperty(value = "日志行状态")
	private String instanceStatus;

	@ApiModelProperty(value = "日志行状态中文")
	private String instanceStatusName;

	@JsonProperty
	public String getInstanceStatusName() {
		return InstanceStatus.fromCode(instanceStatus);
	}

	@ApiModelProperty(value = "开始时间")
	private LocalDateTime startTime;

	@ApiModelProperty(value = "执行时间")
	private LocalDateTime executeTime;

	@ApiModelProperty(value = "结束时间")
	private LocalDateTime endTime;

	@ApiModelProperty(value = "错误日志")
	private String errorMessage;

	@ApiModelProperty(value = "日志链路ID")
	private String traceId;

	@ApiModelProperty(value = "自定义字段(JSON字符串)")
	private String customFields;

	@ApiModelProperty(value = "租户ID")
	private Long tenantId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;
}
