package com.elitesland.cbpl.rosefinch.enums;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.common.base.EnumValues;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Getter
public enum InstanceStatus {

    /**
     * 实例状态
     */
    READY("就绪"),
    RUNNING("进行中"),
    COMPLETE("已完成"),
    INTERRUPT("异常中断"),
    STOP("手动终止"),
    SHUTDOWN("服务关停"),
    ;

    private final String desc;

    public String getCode() {
        return this.name();
    }

    InstanceStatus(String desc) {
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (InstanceStatus status : InstanceStatus.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }

    public static List<EnumValues> enumValues() {
        return Arrays.stream(InstanceStatus.values())
                .map(name -> EnumValues.of(name.getCode(), name.getDesc()))
                .collect(Collectors.toList());
    }

    /**
     * 可以任务删除的状态：完成、异常中断、手动终止、服务关停
     */
    public static List<String> deletionStatus() {
        return ListUtil.of(COMPLETE.getCode(), INTERRUPT.getCode(), STOP.getCode(), SHUTDOWN.getCode());
    }
}
