/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.dynamictp.vm.v107.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtp.core.DtpRegistry;
import com.dtp.core.support.ThreadPoolBuilder;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.elitesland.cbpl.dynamictp.domain.TpProperty;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dtp107Service
implements DtpService<DtpExecutor> {
    private static final Logger logger = LoggerFactory.getLogger(Dtp107Service.class);

    @Override
    public <T extends TpProperty> DtpExecutor createDtpExecutor(T property) {
        return ThreadPoolBuilder.newBuilder().threadPoolName(property.getThreadPoolName()).threadFactory(property.getThreadPrefix()).corePoolSize(property.getCorePoolSize()).maximumPoolSize(property.getMaximumPoolSize()).queueCapacity(property.getQueueCapacity()).rejectedExecutionHandler(property.getRejectPolicy()).buildDynamic();
    }

    @Override
    public <T extends TpProperty> ScheduledExecutorService createScheduledExecutor(T property) {
        return new ScheduledThreadPoolExecutor(property.getCorePoolSize(), (ThreadFactory)new NamedThreadFactory(property.getThreadPrefix()), new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public <T extends TpProperty> DtpExecutor getTaskExecutor(T property) {
        if (ObjectUtil.isNotNull(property)) {
            if (DtpRegistry.listAllDtpNames().contains(property.getThreadPoolName())) {
                return DtpRegistry.getDtpExecutor((String)property.getThreadPoolName());
            }
            return ThreadPoolBuilder.newBuilder().threadPoolName(property.getThreadPoolName()).threadFactory(StrUtil.blankToDefault((CharSequence)property.getThreadPrefix(), (String)property.getThreadPoolName())).corePoolSize(property.getCorePoolSize()).maximumPoolSize(property.getMaximumPoolSize()).queueCapacity(property.getQueueCapacity()).rejectedExecutionHandler(property.getRejectPolicy()).buildDynamic();
        }
        return DtpRegistry.getDtpExecutor((String)property.getThreadPoolName());
    }
}

