package com.elitesland.cbpl.dynamictp.service;

import com.elitesland.cbpl.dynamictp.domain.TpProperty;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author eric.hao
 * @since 2024/08/19
 */
public interface DtpService<R extends ThreadPoolExecutor> {

    /**
     * Create DtpExecutor by thread pool property.
     */
    <T extends TpProperty> R createDtpExecutor(T property);

    /**
     * Build scheduled thread pool executor.
     */
    <T extends TpProperty> ScheduledExecutorService createScheduledExecutor(T property);

    /**
     * Get DtpExecutor by thread pool property.
     */
    <T extends TpProperty> R getTaskExecutor(T property);
}
