package com.elitesland.cbpl.rosefinch.proxy;

import com.elitesland.cbpl.rosefinch.data.entity.RosefinchConfigDO;
import com.elitesland.cbpl.rosefinch.data.repo.RosefinchConfigRepo;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/08/09
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class RosefinchRegister {

    private final RosefinchConfigRepo rosefinchConfigRepo;
    private final RosefinchConfigService rosefinchConfigService;

    /**
     * 任务注册
     *
     * @param saveParam 注册参数
     * @return 任务ID
     */
    public Long register(RosefinchConfigSaveParamVO saveParam) {
        Optional<RosefinchConfigDO> rosefinchConfigDO = rosefinchConfigRepo.findByTaskCode(saveParam.getTaskCode());
        if (rosefinchConfigDO.isPresent()) {
            return rosefinchConfigDO.get().getId();
        }
        return rosefinchConfigService.save(saveParam);
    }
}
