/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.dynamictp.vm.v117.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.dynamictp.domain.TpProperty;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import java.util.concurrent.ScheduledExecutorService;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dtp117Service
implements DtpService<DtpExecutor> {
    private static final Logger logger = LoggerFactory.getLogger(Dtp117Service.class);

    @Override
    public <T extends TpProperty> DtpExecutor createDtpExecutor(T property) {
        return ThreadPoolBuilder.newBuilder().threadPoolName(property.getThreadPoolName()).threadFactory(property.getThreadPrefix()).corePoolSize(property.getCorePoolSize()).maximumPoolSize(property.getMaximumPoolSize()).queueCapacity(property.getQueueCapacity()).rejectedExecutionHandler(property.getRejectPolicy()).eager().buildDynamic();
    }

    @Override
    public <T extends TpProperty> ScheduledExecutorService createScheduledExecutor(T property) {
        return ThreadPoolBuilder.newBuilder().threadPoolName(property.getThreadPoolName()).threadFactory(property.getThreadPrefix()).corePoolSize(property.getCorePoolSize()).maximumPoolSize(property.getMaximumPoolSize()).queueCapacity(property.getQueueCapacity()).rejectedExecutionHandler(property.getRejectPolicy()).buildScheduled();
    }

    @Override
    public <T extends TpProperty> DtpExecutor getTaskExecutor(T property) {
        if (ObjectUtil.isNotNull(property)) {
            if (DtpRegistry.getAllExecutorNames().contains(property.getThreadPoolName())) {
                return DtpRegistry.getDtpExecutor((String)property.getThreadPoolName());
            }
            return ThreadPoolBuilder.newBuilder().threadPoolName(property.getThreadPoolName()).threadFactory(StrUtil.blankToDefault((CharSequence)property.getThreadPrefix(), (String)property.getThreadPoolName())).corePoolSize(property.getCorePoolSize()).maximumPoolSize(property.getMaximumPoolSize()).queueCapacity(property.getQueueCapacity()).rejectedExecutionHandler(property.getRejectPolicy()).eager().buildDynamic();
        }
        return DtpRegistry.getDtpExecutor((String)property.getThreadPoolName());
    }
}

