/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.config;

import com.dtp.core.spring.EnableDynamicTp;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.starter.common.autoconfigure.BaseBeanAutoConfiguration;
import com.elitesland.cbpl.dynamictp.service.DtpConstService;
import com.elitesland.cbpl.dynamictp.service.DtpService;
import com.elitesland.cbpl.dynamictp.vm.v107.service.Dtp107Service;
import com.elitesland.cbpl.dynamictp.vm.v107.service.DtpConst107Service;
import com.elitesland.cbpl.dynamictp.vm.v117.service.Dtp117Service;
import com.elitesland.cbpl.dynamictp.vm.v117.service.DtpConst117Service;
import com.elitesland.cbpl.rosefinch.config.RosefinchProperties;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.queue.producer.DefaultQueueProducer;
import org.dromara.dynamictp.core.spring.DtpBaseBeanConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RosefinchProperties.class})
@ConditionalOnProperty(prefix="cbpl.rosefinch", name={"enabled"}, havingValue="true")
public class RosefinchAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="cbpl.rosefinch", name={"queue-strategy"}, havingValue="default", matchIfMissing=true)
    public QueueHandlerService defaultQueueProducer() {
        logger.info("[ROSEFINCH] Registry DefaultQueueProducer.");
        return new DefaultQueueProducer();
    }

    @Bean
    public QueueProxy queueProxy(QueueHandlerService handlerService) {
        logger.info("[ROSEFINCH] Registry QueueProxy.");
        return new QueueProxy(handlerService);
    }

    @Configuration
    @ConditionalOnProperty(prefix="cbpl.rosefinch", name={"version"}, havingValue="dynamic_107")
    @EnableDynamicTp
    @EnableAutoConfiguration(exclude={DtpBaseBeanConfiguration.class})
    public static class EnableDtp107 {
        @Bean
        public DtpService<DtpExecutor> dtpService() {
            logger.info("[ROSEFINCH] Load DynamicTp v1.0.7.");
            return new Dtp107Service();
        }

        @Bean
        public DtpConstService dtpConstService() {
            return new DtpConst107Service();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="cbpl.rosefinch", name={"version"}, havingValue="dynamic_117", matchIfMissing=true)
    @org.dromara.dynamictp.core.spring.EnableDynamicTp
    @EnableAutoConfiguration(exclude={BaseBeanAutoConfiguration.class})
    public static class EnableDtp117 {
        @Bean
        public DtpService<org.dromara.dynamictp.core.executor.DtpExecutor> dtpService() {
            logger.info("[ROSEFINCH] Load DynamicTp v1.1.7.");
            return new Dtp117Service();
        }

        @Bean
        public DtpConstService dtpConstService() {
            return new DtpConst117Service();
        }
    }
}

