/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.data.controller;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceDeleteParamVO;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchInstanceDetailVO;
import com.elitesland.cbpl.rosefinch.enums.InstanceStatus;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u8fd0\u7ef4\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/rosefinch/devops"})
public class RosefinchOpsController {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchOpsController.class);
    private final RosefinchConfigService configService;
    private final RosefinchInstanceService instanceService;

    @ApiOperation(value="\u5220\u9664\u5b9e\u4f8b\u65e5\u5fd7")
    @DeleteMapping(value={"/task/delete/instance"})
    public HttpResult<Long> delete(@Valid @RequestBody RosefinchInstanceDeleteParamVO paramVO) {
        logger.info("[Rosefinch] delete instance param = {}", (Object)paramVO);
        return HttpResult.ok((Object)this.instanceService.deleteInstance(paramVO, "INVOKE"));
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4e00\u6b21")
    @PostMapping(value={"/task/execute"})
    public HttpResult<Void> execute(String taskCode) {
        logger.info("[Rosefinch] execute immediately, taskCode = {}", (Object)taskCode);
        this.configService.execute(taskCode);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7acb\u5373\u7ec8\u6b62")
    @PostMapping(value={"/instance/stop"})
    public HttpResult<Boolean> stop(Long instanceId) {
        logger.info("[Rosefinch] stop immediately, instanceId = {}", (Object)instanceId);
        RosefinchInstanceDetailVO instance = this.instanceService.rosefinchInstanceById(instanceId);
        if (ObjectUtil.isNull((Object)instance)) {
            throw new RuntimeException("\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        List status = ListUtil.of((Object[])new String[]{InstanceStatus.READY.getCode(), InstanceStatus.RUNNING.getCode()});
        if (!status.contains(instance.getInstanceStatus())) {
            throw new RuntimeException(instance.getInstanceStatusName() + "\u7684\u4efb\u52a1\u4e0d\u80fd\u7ec8\u6b62");
        }
        return HttpResult.ok((Object)this.configService.stopImmediately(instanceId));
    }

    public RosefinchOpsController(RosefinchConfigService configService, RosefinchInstanceService instanceService) {
        this.configService = configService;
        this.instanceService = instanceService;
    }
}

