package com.elitesland.cbpl.rosefinch.queue.topic;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import lombok.Data;

import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/09/29
 */
@Data
public class QueueTopic {

    /**
     * Saves the MDC value of the current thread
     */
    private Map<String, String> parentMdc;

    /**
     * 任务实例
     */
    private RosefinchInstanceSaveParamVO instance;

    /**
     * 任务执行内容
     */
    private Runnable runnable;

    /**
     * 租户编码【可能为空】
     */
    private String tenantCode;

    /**
     * 任务编码
     */
    public String getTaskCode() {
        return instance.getTaskCode();
    }
}
