/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.proxy;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.constant.SuccessTag;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.domain.TaskRequestParam;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.spi.RosefinchListener;
import com.elitesland.cbpl.rosefinch.spi.convert.InstanceDtoConvert;
import com.elitesland.cbpl.rosefinch.spi.domain.InstanceDTO;
import com.elitesland.cbpl.rosefinch.util.RosefinchTraceUtil;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

public class QueueProxy {
    private static final Logger logger = LoggerFactory.getLogger(QueueProxy.class);
    @Autowired(required=false)
    private RosefinchListener rosefinchListener;
    @Resource
    private RosefinchInstanceService instanceService;
    private final QueueHandlerService handlerService;

    private RosefinchInstanceSaveParamVO instanceLog(TaskRequestParam request, String runType) {
        RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
        saveParam.setMasId(request.getTaskId());
        saveParam.setTraceId(RosefinchTraceUtil.getTraceId());
        saveParam.setTaskName(request.getTaskName());
        saveParam.setTaskCode(request.getTaskCode());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setInstanceStatus(InstanceStatus.READY.getCode());
        saveParam.setRunType(runType);
        saveParam.setMethodArgs(request.getMethodArgs());
        Long instanceId = this.instanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    public Runnable runAuto(TaskRequestParam request) {
        Runnable executor = () -> this.runImmediately(request, "\u81ea\u52a8\u6267\u884c");
        if (RosefinchUtil.noTenant()) {
            return executor;
        }
        return () -> TenantSpiUtil.byTenantDirectly((Runnable)executor, (String)TenantSpiUtil.currentTenantCode());
    }

    public Long runImmediately(TaskRequestParam request) {
        return this.runImmediately(request, "\u624b\u52a8\u6267\u884c");
    }

    public Long runImmediately(TaskRequestParam request, String runType) {
        RosefinchTraceUtil.initTraceId();
        RosefinchInstanceSaveParamVO instance = this.instanceLog(request, runType);
        this.handlerService.publish(instance, () -> {
            Object bean = SpringUtils.getClassBean((String)request.getClassName());
            if (StrUtil.isNullOrUndefined((CharSequence)request.getMethodArgs())) {
                Method method = ReflectionUtils.findMethod(bean.getClass(), (String)request.getMethod());
                ReflectionUtils.invokeMethod((Method)method, (Object)bean);
            } else {
                Method method = ReflectionUtils.findMethod(bean.getClass(), (String)request.getMethod(), (Class[])new Class[]{String.class});
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{request.getMethodArgs()});
            }
        });
        RosefinchTraceUtil.clearTraceId();
        return instance.getId();
    }

    public boolean stopImmediately(Long instanceId) {
        try {
            LogUtil.info((String)"[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1...");
            boolean stopTag = this.handlerService.stopImmediately(RosefinchUtil.instanceKey(instanceId));
            RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
            saveParam.setId(instanceId);
            saveParam.setEndTime(LocalDateTime.now());
            if (stopTag) {
                saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
            }
            saveParam.setRemark("\u624b\u52a8\u7ec8\u6b62\uff1a" + SuccessTag.fromCode(stopTag));
            this.instanceService.update(saveParam);
            LogUtil.info((String)("[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\uff1a" + SuccessTag.fromCode(stopTag)));
            return stopTag;
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            LogUtil.error((String)"[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    public void execute(RosefinchInstanceSaveParamVO instance, Runnable runnable) {
        LogUtil.info((String)("[ROSEFINCH] \u4efb\u52a1(" + instance.getTaskCode() + ") \u5f00\u59cb\u6267\u884c\uff1a"));
        try {
            if (this.rosefinchListener != null) {
                InstanceDTO instanceDTO = InstanceDtoConvert.INSTANCE.saveParamToVO(instance);
                this.rosefinchListener.start(instanceDTO);
            }
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u524d\u7f6e\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a", (Throwable)e);
        }
        Exception throwable = null;
        try {
            instance.setInstanceStatus(InstanceStatus.RUNNING.getCode());
            instance.setExecuteTime(LocalDateTime.now());
            this.instanceService.update(instance);
            runnable.run();
            instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
        }
        catch (Exception e) {
            throwable = e;
            instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
            instance.setErrorMessage(ExceptionUtils.formatException((Throwable)e, (int)255));
            LogUtil.error((String)"[ROSEFINCH] \u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        instance.setEndTime(LocalDateTime.now());
        this.instanceService.update(instance);
        LogUtil.info((String)"[ROSEFINCH] \u6267\u884c\u7ed3\u675f.");
        try {
            if (this.rosefinchListener != null) {
                InstanceDTO instanceDTO = InstanceDtoConvert.INSTANCE.saveParamToVO(instance);
                this.rosefinchListener.whenComplete(instanceDTO, throwable);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"[ROSEFINCH] \u540e\u7f6e\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public QueueProxy(QueueHandlerService handlerService) {
        this.handlerService = handlerService;
    }
}

