/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.queue.consumer;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.proxy.QueueProxy;
import com.elitesland.cbpl.rosefinch.queue.topic.QueueTopic;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class QueueConsumer<T extends QueueTopic> {
    public void consumer(T message) {
        this.setContextMap(((QueueTopic)message).getParentMdc());
        if (RosefinchUtil.noTenant()) {
            this.executor(message).run();
        } else {
            TenantSpiUtil.setCurrentTenant((String)((QueueTopic)message).getTenantCode());
            this.executor(message).run();
            TenantSpiUtil.resetCurrentTenant();
        }
    }

    private Runnable executor(T message) {
        return () -> {
            try {
                QueueProxy handler = (QueueProxy)SpringUtil.getBean(QueueProxy.class);
                handler.execute(message.getInstance(), message.getRunnable());
            }
            catch (NoSuchBeanDefinitionException e) {
                LogUtil.error((String)"[ROSEFINCH][DISRUPTOR] \u5904\u7406\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
        };
    }

    private void setContextMap(Map<String, String> context) {
        if (context == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(context);
        }
    }
}

