/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.proxy;

import com.elitesland.cbpl.common.constant.SuccessTag;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.ProducerProxy;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskMessage;
import com.elitesland.cbpl.rosefinch.common.constant.InstanceStatus;
import com.elitesland.cbpl.rosefinch.data.convert.RosefinchConfigConvert;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchInstanceSaveParamVO;
import com.elitesland.cbpl.rosefinch.queue.QueueHandlerService;
import com.elitesland.cbpl.rosefinch.util.RosefinchTraceUtil;
import com.elitesland.cbpl.rosefinch.util.RosefinchUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.lzhpo.tracer.util.TracerUtils;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class ProducerProxyService
implements ProducerProxy {
    private static final Logger logger = LoggerFactory.getLogger(ProducerProxyService.class);
    private final RosefinchInstanceService instanceService;
    private final QueueHandlerService handlerService;

    public Long send(TaskMessage<?> payload, String runType) {
        RosefinchTraceUtil.initTraceId();
        RosefinchInstanceSaveParamVO instance = this.instanceLog(payload, runType);
        payload.setInstanceDTO(RosefinchConfigConvert.INSTANCE.saveParamToDTO(instance));
        this.handlerService.publish(payload);
        RosefinchTraceUtil.clearTraceId();
        return instance.getId();
    }

    public boolean stop(String taskCode, long instanceId) {
        try {
            LogUtil.info((String)taskCode, null, (String)"[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1...", null, null);
            boolean stopTag = this.handlerService.stopImmediately(RosefinchUtil.instanceKey(instanceId));
            RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
            saveParam.setId(instanceId);
            saveParam.setEndTime(LocalDateTime.now());
            if (stopTag) {
                saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
            }
            saveParam.setRemark("\u624b\u52a8\u7ec8\u6b62\uff1a" + SuccessTag.fromCode((boolean)stopTag));
            this.instanceService.update(saveParam);
            LogUtil.info((String)taskCode, null, (String)("[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\uff1a" + SuccessTag.fromCode((boolean)stopTag)), null, null);
            return stopTag;
        }
        catch (Exception e) {
            logger.error("[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            LogUtil.error((String)"[ROSEFINCH] \u7ec8\u6b62\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    private RosefinchInstanceSaveParamVO instanceLog(TaskMessage<?> payload, String runType) {
        RosefinchInstanceSaveParamVO saveParam = new RosefinchInstanceSaveParamVO();
        saveParam.setMasId(payload.getTaskId());
        saveParam.setTaskName(payload.getTaskName());
        saveParam.setTaskCode(payload.getTaskCode());
        saveParam.setRunType(runType);
        saveParam.setInstanceStatus(InstanceStatus.READY.getCode());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setGlobalTraceId(TracerUtils.getTraceId());
        saveParam.setTraceId(RosefinchTraceUtil.getTraceId());
        saveParam.setMethodArgs(BeanUtils.toJsonOrEmpty((Object)payload.getPayload()));
        if (RosefinchType.BATCH.getCode().compareTo(payload.getTaskType()) == 0) {
            saveParam.setTotalCount(payload.size());
            saveParam.setSuccessCount(0);
            saveParam.setFailCount(0);
        }
        Long instanceId = this.instanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    public ProducerProxyService(RosefinchInstanceService instanceService, QueueHandlerService handlerService) {
        this.instanceService = instanceService;
        this.handlerService = handlerService;
    }
}

