package com.elitesland.cbpl.rosefinch.config;

import com.elitesland.cbpl.common.constant.QueueStrategy;
import com.elitesland.cbpl.logging.common.constant.DeletionStrategy;
import com.elitesland.cbpl.rosefinch.constant.TenantIsolateStrategy;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.ROSEFINCH_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/08/05
 */
@Data
@ConfigurationProperties(prefix = ROSEFINCH_CONFIG_PREFIX)
public class RosefinchProperties implements InitializingBean {

    public static final String ROSEFINCH_CONFIG_PREFIX = "cbpl.rosefinch";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 是否为多节点集群
     */
    private boolean cluster;

    /**
     * 分布式锁时间，单位(秒)
     * <li>多节点集群环境时生效</li>
     * <li>默认10秒</li>
     */
    private int expireDuration = 10;

    /**
     * 实例日志，默认保留的天数
     */
    private String deletionStrategy = DeletionStrategy.NO_DELETION.getDays();

    /**
     * 实例定时删除任务频率，默认每天凌晨`01:20:00`执行
     */
    private String deletionStrategyCron = "0 20 1 * * ?";

    /**
     * 队列策略
     * {@link QueueStrategy}
     */
    private String queueStrategy = "default";

    /**
     * 租户隔离策略，默认不隔离
     */
    private TenantIsolateStrategy tenantIsolateStrategy = TenantIsolateStrategy.NONE;

    public static boolean ROSEFINCH_ENABLED;
    public static boolean ROSEFINCH_CLUSTER;
    public static int ROSEFINCH_EXPIRE_DURATION;
    public static String ROSEFINCH_DELETION_DAYS;
    public static String ROSEFINCH_DELETION_CRON;
    public static String ROSEFINCH_QUEUE_STRATEGY;
    public static TenantIsolateStrategy TENANT_ISOLATE_STRATEGY;

    @Override
    public void afterPropertiesSet() throws Exception {
        ROSEFINCH_ENABLED = enabled;
        ROSEFINCH_CLUSTER = cluster;
        ROSEFINCH_EXPIRE_DURATION = expireDuration;
        ROSEFINCH_DELETION_DAYS = deletionStrategy;
        ROSEFINCH_DELETION_CRON = deletionStrategyCron;
        ROSEFINCH_QUEUE_STRATEGY = queueStrategy;
        TENANT_ISOLATE_STRATEGY = tenantIsolateStrategy;
    }
}
