package com.elitesland.cbpl.rosefinch.util;

import com.elitesland.cbpl.rosefinch.constant.TenantIsolateStrategy;
import com.elitesland.cbpl.tool.core.util.StringUtils;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;

import static com.elitesland.cbpl.rosefinch.config.RosefinchProperties.TENANT_ISOLATE_STRATEGY;
import static com.elitesland.cbpl.rosefinch.constant.RosefinchConstant.RF_TOPIC_PREFIX;

/**
 * @author eric.hao
 * @since 2024/08/06
 */
public class RosefinchUtil {

    /**
     * 是否整合了租户环境
     */
    public static boolean noTenant() {
        // 配置不隔离 or 未对`TenantClientSpi`开发实现类
        return TENANT_ISOLATE_STRATEGY.equals(TenantIsolateStrategy.NONE) || !SpringUtils.isPresent(TenantClientSpi.class);
    }

    /**
     * 任务主键，按租户区分
     */
    public static String instanceKey(Long instanceId) {
        // 租户不隔离
        if (noTenant()) {
            return String.valueOf(instanceId);
        }
        return StringUtils.tenantKey(String.valueOf(instanceId));
    }

    /**
     * Topic + Tag
     */
    public static String topicTags(String tag) {
        return RF_TOPIC_PREFIX + ":" + tag;
    }
}
